/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.bridge;

import ibm.nways.jdm.I18NGiblets;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JdmServerImpl;
import ibm.nways.jdm.StatusType;
import ibm.nways.jdm.modelgen.StatusMapper;
import ibm.nways.jdm.modelgen.StatusModelInfo;
import ibm.nways.jdm.modelgen.TableStatusNamer;
import java.io.Serializable;

public class ActionBridge
implements StatusMapper,
TableStatusNamer {
    private static String enumBundle = "ibm.nways.bridge.eui.EnumeratedResources";
    private static String bridgeBundle = "ibm.nways.bridge.Resources";
    private boolean loggingOn = false;

    public ActionBridge() {
        String string = JdmServerImpl.getProperty("startLogging");
        if (string != null && string.equals("yes")) {
            this.loggingOn = true;
        }
    }

    public void calculateStatus(StatusModelInfo statusModelInfo, StatusModelInfo statusModelInfo2) {
        if (this.loggingOn) {
            System.out.println("ActionBridge");
        }
        Serializable[] serializableArray = statusModelInfo.getIndexes();
        int n = (Integer)serializableArray[0];
        if (this.loggingOn) {
            System.out.println("StpPortState = " + statusModelInfo.get("Panel.Dot1dStpPortState") + n);
        }
        Integer n2 = (Integer)statusModelInfo.get("Panel.Dot1dStpPortState");
        int n3 = n2;
        StatusAndExplain statusAndExplain = this.evaluateStpPortState(n3, n);
        statusModelInfo.setStatusType(statusAndExplain.statType, statusAndExplain.explain, true);
    }

    public I18NString nameThatObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionBridge - nameThatObject");
        }
        Object[] objectArray = statusModelInfo.getIndexes();
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat(bridgeBundle, "STATUS_NAME", objectArray);
        return i18NMsgFormat;
    }

    public I18NString nameThatTableObject(StatusModelInfo statusModelInfo) {
        if (this.loggingOn) {
            System.out.println("ActionBridge - nameThatTableObject");
        }
        I18NString i18NString = new I18NString(bridgeBundle, "STATUS_TABLE_BRIDGE");
        return i18NString;
    }

    private StatusAndExplain evaluateStpPortState(int n, int n2) {
        StatusAndExplain statusAndExplain = new StatusAndExplain();
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = new Object[]{new Integer(n2)};
        objectArray[0] = new I18NMsgFormat(bridgeBundle, "bridgestatus", objectArray2);
        if (n == 1) {
            statusAndExplain.statType = StatusType.ADMIN_DISABLED;
            objectArray[0] = new I18NMsgFormat(bridgeBundle, "bridgeenable", objectArray2);
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bridge.model.PortsModel.Panel.Dot1dStpPortEnable.disabled");
        } else if (n == 2) {
            statusAndExplain.statType = StatusType.NORMAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bridge.model.PortsModel.Panel.Dot1dStpPortState.blocking");
        } else if (n == 3) {
            statusAndExplain.statType = StatusType.MARGINAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bridge.model.PortsModel.Panel.Dot1dStpPortState.listening");
        } else if (n == 4) {
            statusAndExplain.statType = StatusType.MARGINAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bridge.model.PortsModel.Panel.Dot1dStpPortState.learning");
        } else if (n == 5) {
            statusAndExplain.statType = StatusType.NORMAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bridge.model.PortsModel.Panel.Dot1dStpPortState.forwarding");
        } else if (n == 6) {
            statusAndExplain.statType = StatusType.CRITICAL;
            objectArray[1] = new I18NString(enumBundle, "ibm.nways.bridge.model.PortsModel.Panel.Dot1dStpPortState.broken");
        } else {
            statusAndExplain.statType = StatusType.UNKNOWN;
            objectArray[1] = new I18NString(enumBundle, "unknown");
        }
        statusAndExplain.explain = new I18NGiblets(bridgeBundle, "statusorder", objectArray);
        if (this.loggingOn) {
            System.out.println("statType = " + statusAndExplain.statType);
            System.out.println("explain  = " + statusAndExplain.explain.getTranslation());
        }
        return statusAndExplain;
    }

    private class StatusAndExplain {
        StatusType statType;
        I18NGiblets explain;

        StatusAndExplain() {
            ActionBridge.this = ActionBridge.this;
        }
    }
}

